using CRM007.CRM.SDK.Core;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Client;
using System;
using System.Diagnostics;
using System.Collections.Generic;
using VRM.Integration.Servicebus.Core;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VideoVisit.Services;
using VIMT.VideoVisit.Services.XSD;
using VIMT.VideoVisit.Services.Rest;
using System.Net.Http;
 using Logger = VRM.Integration.Servicebus.Core.Logger;
namespace VIMT.VideoVisit.Processors
{
	class VIMTTmpCancelAppointmentProcessor 
	{
	/// <summary>
	/// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,DeleteMeeting method, Processpr.
	/// Code Generated by IMS on: 4/12/2016 6:50:07 PM
	/// Version: 2016.04.08
	/// </summary>
	/// <param name=none></param>
	/// <returns>none</returns>
        public IMessageBase Execute(VIMTTmpCancelAppointmentRequest request)
		{
			//var request = message as DeleteMeetingRequest;
            VIMTTmpCancelAppointmentResponse response = null;
			var progressString = "Top of Processor";
			try
			{
				if (request == null)
				{
					Logger.Instance.Warn(string.Format("{0} recieved a null message", GetType().FullName));
				}
				else
				{
				#region do legacy webservice calls
					string method = "DeleteMeetingProcessor", webService = "DeleteMeeting";

                    var DeleteMeetingResponse = new WriteResults();
					Stopwatch thisTimer = Stopwatch.StartNew();
						
					try
					{
						SoapLog.Current.Active = true;
                        var DeleteMeetingRequestData = new CancelAppointmentRequest
                         {
                             Id = request.VIMTTmpCancelAppointmentRequestDataInfo.Id,
                             PatientBookingStatuses = new PersonBookingStatuses(),
                             SourceSystem = request.VIMTTmpCancelAppointmentRequestDataInfo.SourceSystem
                         };

					    if (request.VIMTTmpCancelAppointmentRequestDataInfo.PatientBookingStatuses?.PersonBookingStatus != null && 
                            request.VIMTTmpCancelAppointmentRequestDataInfo.PatientBookingStatuses.PersonBookingStatus.Length > 0)
					    {
					        DeleteMeetingRequestData.PatientBookingStatuses.PersonBookingStatus = new List<PersonBookingStatus>();

					        foreach (var personBooking in request.VIMTTmpCancelAppointmentRequestDataInfo.PatientBookingStatuses.PersonBookingStatus)
					        {
					            var bookingStatus = new PersonBookingStatus
					            {
					                Id = new PersonIdentifier
					                {
					                    UniqueId = personBooking.Id.UniqueId,
					                    AssigningAuthority = personBooking.Id.AssigningAuthority
					                },
                                    Status = new Status { Description = personBooking.Status.Description }
					            };

					            if (personBooking.Status.CodeSpecified)
					            {
					                bookingStatus.Status.Code = (StatusCode) personBooking.Status.Code;
					                bookingStatus.Status.CodeSpecified = true;
					            }

					            if (personBooking.Status.ReasonSpecified)
					            {
					                bookingStatus.Status.Reason = (ReasonCode) personBooking.Status.Reason;
					                bookingStatus.Status.ReasonSpecified = true;
					            }

                                DeleteMeetingRequestData.PatientBookingStatuses.PersonBookingStatus.Add(bookingStatus);
                            }
					    }

                        DeleteMeetingResponse = ServiceFactory.CancelAppointment(DeleteMeetingRequestData, request.VIMTTmpCancelAppointmentRequestDataInfo.SamlToken);
						thisTimer.Stop();
						LogHelper.LogInfo(request.OrganizationName, request.LogSoap, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, SoapLog.Current.Log, thisTimer.ElapsedMilliseconds);
						SoapLog.Current.Active = false;
						SoapLog.Current.ClearLog();
						LogHelper.LogTiming(request.OrganizationName, request.LogTiming, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, webService,thisTimer.ElapsedMilliseconds);
					}
					catch (Exception ex)
					{
						thisTimer.Stop();
						LogHelper.LogInfo(request.OrganizationName, request.LogSoap, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, SoapLog.Current.Log, thisTimer.ElapsedMilliseconds);
						SoapLog.Current.Active = false;
						SoapLog.Current.ClearLog();
						LogHelper.LogTiming(request.OrganizationName, request.LogTiming, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, webService,thisTimer.ElapsedMilliseconds);
                        if (response == null) response = new VIMTTmpCancelAppointmentResponse();
						var messageTest = ex.Message.ToLower();
						if (messageTest.Contains("no records"))
						{
							return response;
						}
						if (messageTest.Contains("shareexception"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						if (messageTest.Contains("access violation"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						if (messageTest.Contains("sensitive"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						LogHelper.LogError(request.OrganizationName, request.UserId, "DeleteMeeting Processor", ex);
						response.ExceptionOccured = true;
						response.ExceptionMessage = messageTest;
						return response;
					}
						
					progressString = "Before Mapping";
					try
					{
                        response = new VIMTTmpCancelAppointmentResponse();
						//DeleteMeetingResponse Mapping 
						#region  DeleteMeetingResponse Mapping 
                        var VIMTTmpCancelAppointmentResponseData = new VIMTTmpCancelAppointmentResponseData();
                        VIMTTmpCancelAppointmentResponseData.HttpStatusCode = "OK";
                        VIMTTmpCancelAppointmentResponseData.VIMTTmpWriteResults = new VIMTTmpWriteResults();
                        VIMTTmpCancelAppointmentResponseData.VIMTTmpWriteResults.VIMTTmpWriteResult = new VIMTTmpWriteResult[DeleteMeetingResponse.WriteResult.Count];
                        var index = 0;
                        foreach (var result in DeleteMeetingResponse.WriteResult)
                        {
                            var writeResult = new VIMTTmpWriteResult
                            {
                                PersonId = result.PersonId,
                                FacilityCode = result.FacilityCode,
                                FacilityName = result.FacilityName,
                                ClinicIen = result.ClinicIEN,
                                ClinicName = result.ClinicName,
                                DateTime = result.DateTime,
                                VistaStatus = (VIMT.VideoVisit.Messages.VIMTTmpVistaStatus)Enum.Parse(typeof(VIMT.VideoVisit.Messages.VIMTTmpVistaStatus), result.VistaStatus.ToString(), true),
                                Reason = result.Reason
                            };
                            if (result.Name != null) writeResult.Name = new VIMTTmpPersonName { FirstName = result.Name.FirstName, LastName = result.Name.LastName };
                            VIMTTmpCancelAppointmentResponseData.VIMTTmpWriteResults.VIMTTmpWriteResult.SetValue(writeResult, index);
                            index++;
                        }
                        response.VIMTTmpCancelAppointmentResponseDataInfo = VIMTTmpCancelAppointmentResponseData;
                        
                        //No records existed beyond parent 
						#endregion
					}
					catch (Exception ex)
					{
                        Logger.Instance.Error(string.Format("Error in VVS CancelAppointment Processor EC: Error is: {0}", ex.Message));
                        LogHelper.LogError(request.OrganizationName, request.UserId, "deletemeeting Processor, Progess:" + progressString, ex);
                        if (response == null) response = new VIMTTmpCancelAppointmentResponse();
                        response.ExceptionOccured = true;
                        response.ExceptionMessage = ex.Message;
                        return response;
					}
				#endregion
			}
                Logger.Instance.Debug("Completed VVS CancelAppointment Processor EC");
			    return response;
			}
			catch (Exception ex)
			{
			    Logger.Instance.Error(string.Format("Error in VVS CancelAppointment Processor EC: Error is: {0}", ex.Message));
                LogHelper.LogError(request.OrganizationName, request.UserId, "deletemeeting Processor, Progess:" + progressString, ex);
                if (response == null) response = new VIMTTmpCancelAppointmentResponse();
				response.ExceptionOccured = true;
				response.ExceptionMessage = ex.Message;
				return response;
			}
		}
	}
}